using System;
using System.Collections;
using System.Data;

using UserRoleTable = gov.va.med.vbecs.Common.VbecsTables.UserRole;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Luke Meyer</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/23/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>User role business object</summary>

	#endregion

	public class UserRole : BaseBusinessObject
	{
		private const string UnknownRoleName = "Unknown";

		private UserRoleType _userRoleId;
		private string _userRoleName;

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6608"> 
		///		<ExpectedInput>Role type.</ExpectedInput>
		///		<ExpectedOutput>Instantiated object.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6609"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates an instance of the class loading required data from DB.
		/// </summary>
		/// <param name="type">User role type</param>
		public UserRole( UserRoleType type ) 
			: base()
		{					
			if( type == UserRoleType.Unknown )
				LoadUnknownRoleType();
			else
				LoadFromDataRow( DAL.ReferenceData.GetUserRole( (int)type ) );
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6610"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6611"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates an instance of the class loading required data from a supplied <see cref="DataRow"/>.
		/// </summary>
		/// <param name="dtRow"><see cref="DataRow"/> to load data from.</param>
		public UserRole( DataRow dtRow ) : base()
		{
			LoadFromDataRow( dtRow );
		}

		/// <summary>
		/// Initializes an object with "unknown" role type.
		/// </summary>
		private void LoadUnknownRoleType()
		{
			_userRoleId = UserRoleType.Unknown;
			_userRoleName = UnknownRoleName;
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/23/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="280"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>Valid VBECS User Role type.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1805"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///	<summary>
		///	The access permission level granted to the user.
		///	</summary>
		public UserRoleType UserRoleId
		{
			get
			{
				return _userRoleId;
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/23/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="281"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1368"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///	<summary>
		///	Text description of the user's permission level.
		///	</summary>	
		public string UserRoleName
		{
			get
			{
				return _userRoleName;
			}		
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<Update>Unused</Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads an object from a data row.
		/// </summary>
		protected override void LoadFromDataRow( DataRow dtRow )
		{
			if( dtRow == null )
				throw( new ArgumentNullException( "dtRow" ) );

			Utility.RequireNonNullColumns( dtRow, UserRoleTable.UserRoleId, UserRoleTable.UserRoleName );

			int _roleIdAsInt = StDbNullConvert.ToInt32( dtRow[ UserRoleTable.UserRoleId ], (int)UserRoleType.Unknown );

			_userRoleId = Enum.IsDefined( typeof(UserRoleType), _roleIdAsInt ) ? (UserRoleType)_roleIdAsInt : UserRoleType.Unknown;
			_userRoleName = StDbNullConvert.ToString( dtRow[ UserRoleTable.UserRoleName ] );
		}		

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="1352"> 
		///		<ExpectedInput>DataRow.</ExpectedInput>
		///		<ExpectedOutput>Updated DataRow.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1362"> 
		///		<ExpectedInput>Null DataRow.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object.
		/// </summary>
		public override DataRow LoadDataRowFromThis( DataRow dtRow )
		{
			if( dtRow == null )
				throw( new ArgumentNullException( "dtRow" ) );

			Utility.RequireColumns( dtRow, UserRoleTable.UserRoleId );

			dtRow[ UserRoleTable.UserRoleId ] = StDbNullConvert.From( (int)_userRoleId );

			return dtRow;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/23/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5022"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Non-empty list of all user roles.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5023"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves list of all user roles. 
		/// </summary>
		/// <returns>All user roles.</returns>
		public static ArrayList GetAll()
		{
			DataTable _dtRoles = DAL.ReferenceData.GetUserRoleList();
			ArrayList _list = new ArrayList( _dtRoles.Rows.Count );
			
			foreach( DataRow _dr in _dtRoles.Rows )
				_list.Add( new UserRole( _dr ) );

			return _list;
		}
	}
}
